<?php
/**
 * fopen alternative
 * File name: alternate_fopen.php
 * Last modification: 2005-02-21
 * Version: 1.2
 * @author: Unknown, adapted by SysCo/al
 * @package: free tools, LGPL
 *
 * Usage:
 * require_once("alternate_fopen.php");
 * $result = alternate_fopen("url");
 *
 * $result contains the content of the url.
 *
 * Supported URLs:
 * http://www.domainname.com
 * http://www.domainname.com/
 * http://www.domainname.com/page.html
 * http://www.domainname.com:1234/
 * http://www.domainname.com:1234/page.html
 */
function alternate_fopen($url , $maxtries=5, $timeout=10)
{
    $tries = 0;
    $redirecting = true;
    
    while ($redirecting && $tries < $maxtries)
    {
        $tries++;
        // get host name and URI from URL, URI not needed though
        preg_match("/^(http:\/\/)?([^\/^:]+)([:]?)([^\/]*)([\/]?)(.*)/i", $url, $matches);
        $host = $matches[2];

        $port = intval($matches[4]);
        if ($port <= 0)
        {
            $port = 80;
        }
        
        $uri = $matches[5].$matches[6];
        
        $connection = fsockopen($host, $port, $errorNumber, $errorString, $timeout);
        // fsockopen($host, $port, &$errorNumber, &$errorString, $timeout); not supported anymore
        // (Call-time pass-by-reference has been deprecated...)
        
        if ($connection)
        {
            //tell server what document we want
            fputs ($connection, "GET $url HTTP/1.0");
            fputs ($connection, "\r\n");
            //Host isn't required by HTTP/1.0 but some sites complain otherwise
            fputs ($connection, "Host: $host");
            fputs ($connection, "\r\n\r\n");
            
            $headerStart = 0;
            $headerEnd = 0;
            $redirecting = false;
            $contents = "";
            
            while (!feof($connection))
            {
                $currentLine = fgets ($connection, 1024);
                if ($headerEnd && $redirecting)
                {
                    break;
                }
                else if ($headerEnd && !$redirecting)
                {
                    //this is the html from the page
                    $contents = $contents . $currentLine;
                }
                else if ( ereg("^HTTP", $currentLine) )
                {
                    //came to the start of the header
                    $headerStart = 1;
                }
                else if ( $headerStart && ereg("^[\n\r\t ]*$", $currentLine) )
                {
                    //came to the end of the header
                    $headerEnd = 1;
                }
                else
                {
                    //this is the header, if you want it...
                    if (preg_match("/Location: (.+?)\n/is", $currentLine, $matches) )
                    {
                        //redirects are sometimes relative
                        $newurl = $matches[1];
                        if (!preg_match("/http:\/\//i", $newurl, $matches) )
                        {
                            $url .= $newurl;
                        }
                        else
                        {
                            $url = $newurl;
                        }
                        //extra \r's get picked up sometimes
                        //i think only with relative redirects
                        //this is a quick fix.
                        $url = preg_replace("/\r/s", "", $url);
                        $redirecting = true;
                    }
                }
            }
        }
        else
        {
            return "$errstr ($errno)\n";
        }
        
        fclose ($connection);
    }
    return $contents;
}
