<?php

/*********************************************************************
 *
 * tokengrid PDF class :: Extend the tokengrid class with PDF output
 *
 * Demo file, require tokengrid.pdf.class.php and TCPDF
 *
 * TCPDF (http://www.tcpdf.org/) should be in directory ../tcpdf
 *
 *********************************************************************/
 
    require_once('tokengrid.pdf.class.php');
    
    $x_grid_size   = 10;              // Number of columns on the token card
    $y_grid_size   = 10;              // Number of lines on the token card
    $token_length  = 4;               // Number of characters in a token
    $grid_salt     = 'tokengridDEMO'; // Demo grid salt (specific to the application)
    $grid_id       = '44637673';      // Demo grid id (specific to the user)
    $x_card_size   = 86;              // Card width (in mm)
    $y_card_size   = 54;              // Card height (in mm)
    
    $token_grid_pdf = new TokenGridPdf($x_grid_size, $y_grid_size, $token_length, $grid_salt, str_replace("//","/",dirname(__FILE__))."/../tcpdf/", str_replace("//","/",dirname(__FILE__))."/");
    
    $token_grid_pdf->SetDisplayTokenGridId(true);
    $token_grid_pdf->SetFrameAroundGrid(true);
    $token_grid_pdf->SetUtf8EncodingRequired(true);
   
    $token_grid_pdf->setDocumentProperties("TokenGrid","Automated generator","Generated TokenGrid #".$grid_id, "TokenGrid #".$grid_id);
    $token_grid_pdf->setHeader("demo.logo.jpg",8,"Access Card", "My Company Ltd");
    $token_grid_pdf->setCardSize($x_card_size,$y_card_size);
    $token_grid_pdf->setCardPosition(round((210-(2*86))/2,1),140);
    $token_grid_pdf->setStyleHeaderHonrizontal(array(80,80,255),array(255,255,255), 7, "vera", "B", 0.3,array(255,255,255));
    $token_grid_pdf->setStyleHeaderVertical(array(80,80,255),array(255,255,255), 7, "vera", "B", 0.3,array(255,255,255));
    $token_grid_pdf->setStyleCells(array(224,235,255),array(0,0,0), 6, "vera", "B", 0.3,array(255,255,255));
    $token_grid_pdf->setImageFrontCard("demo.bank.png", 'png');
    $token_grid_pdf->setImageFrontPosition('r');
    
    $zone1 = $token_grid_pdf->addTextZone(0,50,"This is your new access card in order\nto access our extranet functionalities",'','C',0,1,0,50,false,0, false, array(255,255,255));
    $token_grid_pdf->getTextZone($zone1)->setFont("vera", 15, array(80,80,255), "BU");

    $zone2 = $token_grid_pdf->addTextZone(150,10,"Please keep this card safely with you.",'','L',0,1,0,80,true,0, false, array(255,255,255));
    $token_grid_pdf->getTextZone($zone2)->setFont("vera", 10, array(0,0,0));
    
    $zone3 = $token_grid_pdf->addTextZone(150,0,"If you are loosing your card, yan can call us directly at +41 12 345 67 89","BTLR",'C',0,1,30,200,true,0, false, array(255,255,255));
    $token_grid_pdf->getTextZone($zone3)->setFont("vera", 9, array(0,0,0),'I');
    $token_grid_pdf->getTextZone($zone1)->setBorder(0.3);
    
    header("Content-type: application/pdf");
    echo $token_grid_pdf->GetPdfGrid($grid_id, "Grid #".$grid_id);

?>